#!/bin/bash

typeset confFile=$1
typeset confFileBasename=`basename $confFile`

typeset base=deployHttpdConf
typeset baseShellScript=${base}.sh
typeset deployLog=${base}.log
typeset errorLog=${base}.error
typeset deploymentsDir=$VAGRANT_DIR/deployments
typeset deployScript=${deploymentsDir}/${baseShellScript}

typeset envScript='../set.env.sh'

rm -f $errorLog
mkdir -p $deploymentsDir

if [ -z $VAGRANT_DIR ] || [ ! -r $VAGRANT_DIR/Vagrantfile ] ; then
	echo '$VAGRANT_DIR must be defined and contain a valid Vagrantfile.  Aborted.' > $errorLog
	exit 1
fi

cat <<-'EOF' > ${deployScript}
#!/bin/bash

typeset confFileBasename=$1
typeset httpDaemon

typeset vetConf='httpd-vet.conf'
typeset mockConf='httpd-vet-mock.conf'
typeset httpdConf='httpd.conf'
typeset destDir='/etc/httpd/conf.d'

if [[ "$confFileBasename" = $vetConf || "$confFileBasename" = $mockConf ]]; then
	httpDaemon=httpd
else
	echo 'Unknown httpd conf.  Aborted.'
	exit
fi

if [[ "$confFileBasename" = $vetConf ]]; then
    rm -f $destDir/$mockConf
elif [[ "$confFileBasename" = $mockConf ]]; then
	cp /vagrant/deployments/$mockConf $destDir
fi

service $httpDaemon restart
EOF

chmod +x $deployScript
cp $confFile $deploymentsDir

cd $VAGRANT_DIR
if [[ -f $envScript ]]; then
	. $envScript
fi
vagrant ssh vamf_apache --command "sudo /vagrant/deployments/$baseShellScript $confFileBasename > $deployLog 2>&1"
